/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class Diskette
extends MediaDevice {
    private String volumeLabel = null;

    Diskette(MediaDeviceIdentifier id) throws MediaDeviceException {
        super(id);
        Trace.trace("XMDADEVT", "-> Diskette.Diskette(MediaDeviceIdentifier = " + id + ")");
        this.mountWithUid = true;
        try {
            Trace.trace("XMDADEVD", "Diskette.Diskette(): Getting the floppy label from within the diskette constructor.");
            this.getLabel();
        }
        catch (MediaDeviceException mdexc) {
            Trace.trace("XMDADEVF", mdexc);
        }
        Trace.trace("XMDADEVT", "<- Diskette.Diskette()");
    }

    boolean isMediaPresent() throws MediaDeviceLockException {
        Trace.trace("XMDADEVT", "-> Diskette.isMediaPresent()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        int rc = -1;
        try {
            String[] isMediaPresentCmd = new String[]{this.mediaServicesParameters.getParm("media.device.check.media.script"), this.mediaDeviceProperties.getDeviceFile(), new Integer(1).toString(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "Diskette.isMediaPresent(): isMediaPresentCmd[0] = " + isMediaPresentCmd[0]);
            Trace.trace("XMDADEVF", "Diskette.isMediaPresent(): isMediaPresentCmd[1] = " + isMediaPresentCmd[1]);
            Trace.trace("XMDADEVF", "Diskette.isMediaPresent(): isMediaPresentCmd[2] = " + isMediaPresentCmd[2]);
            Trace.trace("XMDADEVF", "Diskette.isMediaPresent(): isMediaPresentCmd[3] = " + isMediaPresentCmd[3]);
            rc = RootProcess.executeProgram(isMediaPresentCmd);
            Trace.trace("XMDADEVF", "Diskette.isMediaPresent(): rc = " + rc);
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 623, mdexc).log();
        }
        if (rc == 0) {
            Trace.trace("XMDADEVF", "Diskette.isMediaPresent(): media is present in the device.");
        }
        Trace.trace("XMDADEVT", "<- Diskette.isMediaPresent()");
        return rc == 0;
    }

    public String getLabel() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException {
        Trace.trace("XMDADEVT", "-> Diskette.getLabel()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMediaPresent()) {
            throw new NoMediaPresentException("missing media");
        }
        if (this.isMounted() && this.getFileSystemType() == 1) {
            Trace.trace("XMDADEVF", "Diskette.getLabel(): The vfat diskette is already mounted, returning the label previously found.");
            Trace.trace("XMDADEVT", "<- Diskette.getLabel()");
            return this.volumeLabel;
        }
        Trace.trace("XMDADEVF", "Diskette.getLabel(): Getting the label for the diskette.");
        this.volumeLabel = this.mediaProperties.getLabel(this);
        Trace.trace("XMDADEVF", "Diskette.getLabel(): volumeLabel = " + this.volumeLabel);
        Trace.trace("XMDADEVT", "<- Diskette.getLabel(): returns " + this.volumeLabel);
        return this.volumeLabel;
    }

    String readLabelFile(String labelFile) throws IOException {
        Trace.trace("XMDADEVT", "-> Diskette.readLabelFile(labelFile = " + labelFile + ")");
        String buffer = null;
        String label = null;
        FileReader tfr = new FileReader(labelFile);
        BufferedReader tbr = new BufferedReader(tfr);
        buffer = tbr.readLine();
        if (buffer != null) {
            StringTokenizer st = new StringTokenizer(buffer);
            if (buffer.indexOf("Volume in drive") != -1) {
                Trace.trace("XMDADEVF", "Diskette.readLabelFile(): The label file was created with mdir.");
                if (buffer.indexOf("has no label") == -1) {
                    int numTokens = st.countTokens();
                    for (int i = 0; i < numTokens - 1; ++i) {
                        String token = st.nextToken();
                    }
                    label = st.nextToken();
                    Trace.trace("XMDADEVF", "Diskette.readLabelFile(): The label = " + label);
                } else {
                    Trace.trace("XMDADEVF", "Diskette.readLabelFile(): The diskette has no label.");
                }
            } else {
                Trace.trace("XMDADEVF", "Diskette.readLabelFile(): The label file was created with e2label.");
                if (st.hasMoreTokens()) {
                    label = st.nextToken();
                    Trace.trace("XMDADEVF", "Diskette.readLabelFile(): label = " + label);
                } else {
                    Trace.trace("XMDADEVF", "Diskette.readLabelFile(): The diskette has no label.");
                }
            }
        }
        tfr.close();
        Trace.trace("XMDADEVT", "<- Diskette.readLabelFile(): returns " + label);
        return label;
    }

    public void lockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> Diskette.lockDriveDoor()");
        throw new UnsupportedOperationException();
    }

    public void unLockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> Diskette.unLockDriveDoor()");
        throw new UnsupportedOperationException();
    }

    public void format(String label, int fileSystemType) throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, IllegalArgumentException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "-> Diskette.format(label = " + label + ", " + "fileSystemType = " + fileSystemType + ")");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (fileSystemType != 1 && fileSystemType != 4) {
            throw new IllegalArgumentException("Invalid filesystem type specified to format diskette");
        }
        if (!this.isFormattable()) {
            throw new UnsupportedOperationException("The media device does not support formatting");
        }
        if (!this.isMediaPresent()) {
            throw new NoMediaPresentException("missing media");
        }
        try {
            String[] formatCmd = new String[]{this.mediaServicesParameters.getParm("media.disketteformat.script"), this.mediaDeviceProperties.getDeviceFile(), new Integer(fileSystemType).toString(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log"), label};
            Trace.trace("XMDADEVF", "Diskette.format(): formatCmd[0] = " + formatCmd[0]);
            Trace.trace("XMDADEVF", "Diskette.format(): formatCmd[1] = " + formatCmd[1]);
            Trace.trace("XMDADEVF", "Diskette.format(): formatCmd[2] = " + formatCmd[2]);
            Trace.trace("XMDADEVF", "Diskette.format(): formatCmd[3] = " + formatCmd[3]);
            Trace.trace("XMDADEVF", "Diskette.format(): formatCmd[4] = " + formatCmd[4]);
            int rc = RootProcess.executeProgram(formatCmd);
            Trace.trace("XMDADEVF", "Diskette.format(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("diskette format command failed");
            }
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 624, mdexc).log();
            throw mdexc;
        }
        Trace.trace("XMDADEVT", "<- Diskette.format()");
    }

    public void eject() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> Diskette.eject()");
        throw new UnsupportedOperationException();
    }
}

